export const settingRoutes = [
  {
    path: 'settings',
    name: 'admin.settings.edit',
    redirect: { name: 'admin.settings.general' },
    component: () => import('@/layouts/setting.vue'),
    meta: { pageHeader: false },
    children: [
      {
        path: 'general',
        name: 'admin.settings.general',
        component: () => import('@/pages/Admin/Setting/General.vue'),
        meta: {
          title: 'setting::settings.sections.general',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'application',
        name: 'admin.settings.application',
        component: () => import('@/pages/Admin/Setting/Application.vue'),
        meta: {
          title: 'setting::settings.sections.application',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'logo',
        name: 'admin.settings.logo',
        component: () => import('@/pages/Admin/Setting/Logo.vue'),
        meta: {
          title: 'setting::settings.sections.logo',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'kitchen',
        name: 'admin.settings.kitchen',
        component: () => import('@/pages/Admin/Setting/Kitchen.vue'),
        meta: {
          title: 'setting::settings.sections.kitchen',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'currency',
        name: 'admin.settings.currency',
        component: () => import('@/pages/Admin/Setting/Currency.vue'),
        meta: {
          title: 'setting::settings.sections.currency',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'mail',
        name: 'admin.settings.mail',
        component: () => import('@/pages/Admin/Setting/Mail.vue'),
        meta: {
          title: 'setting::settings.sections.mail',
          permission: 'admin.settings.edit',
        },
      },
      {
        path: 'filesystem',
        name: 'admin.settings.filesystem',
        component: () => import('@/pages/Admin/Setting/Filesystem.vue'),
        meta: {
          title: 'setting::settings.sections.filesystem',
          permission: 'admin.settings.edit',
        },
      },
    ],
  },
]
