export const saleRoutes = [
  {
    path: 'orders',
    name: 'admin.orders',
    meta: {
      title: 'admin::sidebar.orders',
      icon: 'tabler-salad',
    },
    children: [
      {
        path: '',
        name: 'admin.orders.index',
        component: () => import('@/pages/Admin/Order/Index.vue'),
        meta: {
          permission: 'admin.orders.index',
        },
      },
      {
        path: ':id/show',
        name: 'admin.orders.show',
        component: () => import('@/pages/Admin/Order/Show.vue'),
        meta: {
          title: 'admin::resource.show',
          transParam: { resource: 'order::orders.order' },
          permission: 'admin.orders.show',
        },
      },
    ],
  },
  {
    path: 'invoices',
    name: 'admin.invoices',
    meta: {
      title: 'admin::sidebar.invoices',
      icon: 'tabler-file-invoice',
    },
    children: [
      {
        path: '',
        name: 'admin.invoices.index',
        component: () => import('@/pages/Admin/Invoice/Index.vue'),
        meta: {
          permission: 'admin.invoices.index',
        },
      },
      {
        path: ':id/show',
        name: 'admin.invoices.show',
        component: () => import('@/pages/Admin/Invoice/Show.vue'),
        meta: {
          title: 'admin::resource.show',
          transParam: { resource: 'invoice::invoices.invoice' },
          permission: 'admin.invoices.show',
        },
      },
    ],
  },
  {
    path: 'payments',
    name: 'admin.payments',
    meta: {
      title: 'admin::sidebar.payments',
      icon: 'tabler-receipt-dollar',
    },
    children: [
      {
        path: '',
        name: 'admin.payments.index',
        component: () => import('@/pages/Admin/Payment/Index.vue'),
        meta: {
          permission: 'admin.payments.index',
        },
      },
    ],
  },
  {
    path: 'reasons',
    name: 'admin.reasons',
    meta: {
      title: 'admin::sidebar.reasons',
      icon: 'tabler-ban',
    },
    children: [
      {
        path: '',
        name: 'admin.reasons.index',
        component: () => import('@/pages/Admin/Reason/Index.vue'),
        meta: {
          permission: 'admin.reasons.index',
        },
      },
      {
        path: 'create',
        name: 'admin.reasons.create',
        component: () => import('@/pages/Admin/Reason/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'order::reasons.reason' },
          permission: 'admin.reasons.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.reasons.edit',
        component: () => import('@/pages/Admin/Reason/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'order::reasons.reason' },
          permission: 'admin.reasons.edit',
        },
      },
    ],
  },
]
