import { reportAccessMiddleware } from '@/middleware/reportAccess.ts'

export const reportRoutes = [
  {
    path: 'reports',
    name: 'admin.reports',
    meta: {
      title: 'admin::sidebar.reports',
      icon: 'tabler-chart-histogram',
    },
    children: [
      {
        path: '',
        name: 'admin.reports.index',
        component: () => import('@/pages/Admin/Report/Index.vue'),
        meta: {
          permission: 'admin.reports.index',
        },
      },
      {
        path: ':key',
        name: 'admin.reports.show',
        beforeEnter: reportAccessMiddleware,
        component: () => import('@/pages/Admin/Report/Show.vue'),
        meta: {
          permission: 'admin.reports.index',
        },
      },
    ],
  },
]
