export const printerRoutes = [
  {
    path: 'printers',
    name: 'admin.printers',
    meta: {
      title: 'admin::sidebar.printers',
      icon: 'tabler-printer',
    },
    children: [
      {
        path: '',
        name: 'admin.printers.index',
        component: () => import('@/pages/Admin/Printer/Index.vue'),
        meta: {
          permission: 'admin.printers.index',
        },
      },
      {
        path: 'create',
        name: 'admin.printers.create',
        component: () => import('@/pages/Admin/Printer/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'printer::printers.printer' },
          permission: 'admin.printers.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.printers.edit',
        component: () => import('@/pages/Admin/Printer/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'printer::printers.printer' },
          permission: 'admin.printers.edit',
        },
      },
    ],
  },
  {
    path: 'print-agents',
    name: 'admin.print_agents',
    meta: {
      title: 'admin::sidebar.print_agents',
      icon: 'tabler-tournament',
    },
    children: [
      {
        path: '',
        name: 'admin.print_agents.index',
        component: () => import('@/pages/Admin/PrintAgent/Index.vue'),
        meta: {
          permission: 'admin.print_agents.index',
        },
      },
      {
        path: 'create',
        name: 'admin.print_agents.create',
        component: () => import('@/pages/Admin/PrintAgent/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'printer::print_agents.print_agent' },
          permission: 'admin.print_agents.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.print_agents.edit',
        component: () => import('@/pages/Admin/PrintAgent/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'printer::print_agents.print_agent' },
          permission: 'admin.print_agents.edit',
        },
      },
    ],
  },
]
