export const menuRoutes = [
  {
    path: 'menus',
    name: 'admin.menus',
    meta: {
      title: 'menu::menus.menus',
      icon: 'tabler-list-details',
    },
    children: [
      {
        path: '',
        name: 'admin.menus.index',
        component: () => import('@/pages/Admin/Menu/Index.vue'),
        meta: {
          permission: 'admin.menus.index',
        },
      },
      {
        path: 'create',
        name: 'admin.menus.create',
        component: () => import('@/pages/Admin/Menu/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'menu::menus.menu' },
          permission: 'admin.menus.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.menus.edit',
        component: () => import('@/pages/Admin/Menu/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'menu::menus.menu' },
          permission: 'admin.menus.edit',
        },
      },
      {
        path: ':id/categories',
        name: 'admin.menus.categories',
        component: () => import('@/pages/Admin/Category/Index.vue'),
        meta: {
          title: 'admin::sidebar.categories',
          icon: 'tabler-folders',
          permission: 'admin.categories.index',
        },
      },
      {
        path: ':menuId/products',
        name: 'admin.menus.products',
        meta: {
          title: 'admin::sidebar.products',
          icon: 'tabler-package',
        },
        children: [
          {
            path: '',
            name: 'admin.menus.products.index',
            component: () => import('@/pages/Admin/Product/Index.vue'),
            meta: {
              permission: 'admin.products.index',
            },
          },
          {
            path: 'create',
            name: 'admin.menus.products.create',
            component: () => import('@/pages/Admin/Product/Create.vue'),
            meta: {
              title: 'admin::resource.create',
              transParam: { resource: 'product::products.product' },
              permission: 'admin.products.create',
            },
          },
          {
            path: ':id/edit',
            name: 'admin.menus.products.edit',
            component: () => import('@/pages/Admin/Product/Edit.vue'),
            meta: {
              title: 'admin::resource.edit',
              transParam: { resource: 'product::products.product' },
              permission: 'admin.products.edit',
            },
          },
        ],
      },
    ],
  },
  {
    path: 'online-menus',
    name: 'admin.online_menus',
    meta: {
      title: 'menu::online_menus.online_menus',
      icon: 'tabler-link',
    },
    children: [
      {
        path: '',
        name: 'admin.online_menus.index',
        component: () => import('@/pages/Admin/OnlineMenu/Index.vue'),
        meta: {
          permission: 'admin.online_menus.index',
        },
      },
      {
        path: 'create',
        name: 'admin.online_menus.create',
        component: () => import('@/pages/Admin/OnlineMenu/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'menu::online_menus.online_menu' },
          permission: 'admin.online_menus.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.online_menus.edit',
        component: () => import('@/pages/Admin/OnlineMenu/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'menu::online_menus.online_menu' },
          permission: 'admin.online_menus.edit',
        },
      },
    ],
  },
  {
    path: 'categories',
    name: 'admin.categories',
    meta: {
      title: 'admin::sidebar.categories',
      icon: 'tabler-folders',
    },
    children: [
      {
        path: '',
        name: 'admin.categories.index',
        component: () => import('@/pages/Admin/Category/Index.vue'),
        meta: {
          permission: 'admin.categories.index',
        },
      },
    ],
  },
  {
    path: 'products',
    name: 'admin.products',
    meta: {
      title: 'admin::sidebar.products',
      icon: 'tabler-package',
    },
    children: [
      {
        path: '',
        name: 'admin.products.index',
        component: () => import('@/pages/Admin/Product/Index.vue'),
        meta: {
          permission: 'admin.products.index',
        },
      },
      {
        path: 'create',
        name: 'admin.products.create',
        component: () => import('@/pages/Admin/Product/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'product::products.product' },
          permission: 'admin.products.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.products.edit',
        component: () => import('@/pages/Admin/Product/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'product::products.product' },
          permission: 'admin.products.edit',
        },
      },
    ],
  },
]
