export const localizationRoutes = [
  {
    path: 'translations',
    name: 'admin.translations.index',
    component: () => import('@/pages/Admin/Translation/Index.vue'),
    meta: {
      title: 'admin::sidebar.translations',
      icon: 'tabler-language',
      permission: 'admin.translations.index',
    },
  },
  {
    path: 'currency-rates',
    name: 'admin.currency_rates.index',
    component: () => import('@/pages/Admin/CurrencyRate/Index.vue'),
    meta: {
      title: 'admin::sidebar.currency_rates',
      icon: 'ic-outline-currency-exchange',
      permission: 'admin.currency_rates.index',
    },
  },
  {
    path: 'taxes',
    name: 'admin.taxes',
    meta: {
      title: 'admin::sidebar.taxes',
      icon: 'tabler-tax',
    },
    children: [
      {
        path: '',
        name: 'admin.taxes.index',
        component: () => import('@/pages/Admin/Tax/Index.vue'),
        meta: {
          permission: 'admin.taxes.index',
        },
      },
      {
        path: 'create',
        name: 'admin.taxes.create',
        component: () => import('@/pages/Admin/Tax/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'tax::taxes.tax' },
          permission: 'admin.taxes.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.taxes.edit',
        component: () => import('@/pages/Admin/Tax/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'tax::taxes.tax' },
          permission: 'admin.taxes.edit',
        },
      },
    ],
  },
]
