export const branchRoutes = [
  {
    path: 'branches',
    name: 'admin.branches',
    meta: {
      title: 'admin::sidebar.branches',
      icon: 'tabler-git-branch',
    },
    children: [
      {
        path: '',
        name: 'admin.branches.index',
        component: () => import('@/pages/Admin/Branch/Index.vue'),
        meta: {
          permission: 'admin.branches.index',
        },
      },
      {
        path: 'create',
        name: 'admin.branches.create',
        component: () => import('@/pages/Admin/Branch/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'branch::branches.branch' },
          permission: 'admin.branches.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.branches.edit',
        component: () => import('@/pages/Admin/Branch/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'branch::branches.branch' },
          permission: 'admin.branches.edit',
        },
      },
    ],
  },
]
