import type { App } from 'vue'
import { createRouter, createWebHistory } from 'vue-router'
import adminRoutes from '@/router/routes/admin'
import authRoutes from '@/router/routes/auth.ts'
import publicRoutes from '@/router/routes/public.ts'

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [...publicRoutes, ...authRoutes, ...adminRoutes],
})

router.onError((err, to) => {
  if (err?.message?.includes?.('Failed to fetch dynamically imported module')) {
    if (localStorage.getItem('vuetify:dynamic-reload')) {
      // vuetify:dynamic-reload
    } else {
      localStorage.setItem('vuetify:dynamic-reload', 'true')
      location.assign(to.fullPath)
    }
  }
})

router.isReady().then(() => {
  localStorage.removeItem('vuetify:dynamic-reload')
})

export function setupRouter (app: App<Element>) {
  app.use(router)
}

export default router
