import type { App } from 'vue'
import { createVuetify } from 'vuetify'
import { VBtn } from 'vuetify/components/VBtn'
import { ar, en } from 'vuetify/locale'
import { useAppStore } from '@/stores'
import defaults from './defaults'

import { icons } from './icons'
import { themes } from './theme'
import '@/core/scss/template/libs/vuetify/index.scss'
import 'vuetify/styles'

const vuetify = createVuetify({
  defaults,
  icons,
  aliases: {
    IconBtn: VBtn,
  },
  locale: {
    locale: 'en',
    fallback: 'en',
    messages: { en, ar },
  },
  theme: {
    defaultTheme: 'light',
    themes,
  },
})

export function setupVuetify (app: App<Element>) {
  const appStore = useAppStore()

  vuetify.locale.current.value = appStore.appCurrentLocale
  vuetify.locale.fallback.value = appStore.fallbackLocale
  vuetify.theme.change(appStore.appThemeMode)

  app.use(vuetify)
}

export default vuetify
