import { createApp } from 'vue'
import { getAppSettings } from '@/api/setting/setting.ts'
import { getAppTranslations } from '@/api/translation/translation.ts'
import { check } from '@/api/user/auth.ts'
import englishNumbers from '@/directives/englishNumbers.ts'

import englishNumbersWithDecimal from '@/directives/englishNumbersWithDecimal.ts'

import { setupI18n, setupToast, setupVuetify } from '@/plugins'
import { setupRouter } from '@/router'
import { setupStore, useAppStore, useAuthStore } from '@/stores'
import Forkiva from './Forkiva.vue'
import '@/assets/css.ts'

async function bootstrap () {
  const app = createApp(Forkiva)
  setupStore(app)

  app.directive('integer-en', englishNumbers)
  app.directive('decimal-en', englishNumbersWithDecimal)

  const appStore = useAppStore()
  appStore.restoreApp()

  try {
    appStore.setSettings((await getAppSettings()).data.body)
    appStore.setTranslations((await getAppTranslations()).data.body)
  } catch {
    console.error('Failed to retrieve app.')
  }
  setupI18n(app)
  setupVuetify(app)
  setupToast(app)

  const authStore = useAuthStore()
  authStore.restoreAuth()

  if (authStore.isAuthenticated) {
    try {
      const response = await check()
      authStore.setUser(response.data.body.user)
    } catch {
      authStore.logout()
    }
  }

  setupRouter(app)

  app.mount('#app')
}

void bootstrap()
