import type { IconValue } from 'vuetify/lib/composables/icons.js'
import type { DropdownItem } from '@/contracts'

export interface TableHeader {
  title: string
  value: string
  hidden?: boolean
  sortable?: boolean
  sortable_key?: string
}

export interface TableAction {
  key: string
  label?: string
  icon?: IconValue
  color?: string
  permission?: string | string[]
  tooltip?: string
  loading?: boolean
  disabled?: boolean | ((item: any) => boolean)
  hidden?: boolean | ((item: any) => boolean)
  type?: string
  options?: Record<string, any>[]
  onClick?: (item: any) => void | Promise<void>
  confirm?: {
    title?: string
    message?: string
    confirmButtonText?: string
    cancelButtonText?: string
    confirmColor?: string
  }
}

export type TableFilterType =
  | 'text'
  | 'select'
  | 'checkbox'
  | 'switch'
  | 'date'
  | 'number'
  | 'boolean'

export interface TableFilterSchema {
  key: string
  label: string
  type: TableFilterType
  default?: any
  options?: DropdownItem[]
  multiple?: boolean
  clearable?: boolean
  hidden?: boolean
  placeholder?: string
  depends?: string
  menu?: boolean
  dense?: boolean
  cols?: number
  min?: string
  max?: string
}
