export interface Branch {
  id: number
  name: string
}

export interface Customer {
  id: number
  name: string
}

export interface Waiter {
  id: number
  name: string
}

export interface Menu {
  id: number
  name: string
}

export interface openSession {
  id: number
}

export interface Register {
  id: number
  name: string
  session?: null | openSession
}

export interface PosFormMeta {
  notes: null | string
  guestCount: number
  carPlate: null | string
  carDescription: null | string
  scheduledAt: null | string
}

export interface OrderType {
  id: string
  name: string
  icon: string
  color: string
}

export interface Category {
  id: number
  name: string
  logo: string | null
  items: Category[]
}

export interface Product {
  id: number
  name: string
  thumbnail: string | null
  price: Money
  selling_price: Money
  has_special_price: boolean
  is_new: boolean
  category_ids: number[]
  options: ProductOption[]
}

export interface Money {
  amount: number
  formatted: string
  currency: string
  precision: number
}

export interface ProductOption {
  id: number
  name: string
  type: OptionType
  is_required: boolean
  values: OptionValue[]
}

export interface OptionType {
  id: string
  name: string
}

export interface OptionValue {
  id: number
  label: string
  price_type: 'fixed' | 'percent'
  price: Money
}

export interface Discount {
  id: string
  name: string
}

export interface OrderDetails {
  id: number
  reference_no: string
  due_amount: Money
  total: Money
}

export interface Direction {
  id: string
  name: string
  icon: string
  color: string
}

export interface Reason {
  id: string
  name: string
  icon: string
  color: string
}

export interface PosMeta {
  branches: Branch[]
  menus: Menu[]
  registers: Register[]
  orderTypes: OrderType[]
  categories: Category[]
  products: Product[]
  waiters: Waiter[]
  customers: Customer[]
  discounts: Discount[]
  order?: OrderDetails | null
  directions: Direction[]
  reasons: Record<string, Reason[]>
  refundPaymentMethods: Record<string, any>[]
  currency: string
}

export interface PosForm {
  mode: 'create' | 'edit'
  branchId: number | null
  menuId: number | null
  registerId: number | null
  waiter: Waiter | null
  refundPaymentMethod: null | string
  sessionId: number | null
  table?: null | { id: number, name: string, floor: string, zone: string }
  meta: PosFormMeta
  skipFirst: boolean
  loading: boolean
  reloadBranchData: boolean
  loadingMenuItems: boolean
}
