import type { Ref } from 'vue'

export interface Money {
  amount: number
  formatted: string
  currency: string
  precision: number
}

export interface CartItemOptionValue {
  id: number
  label: string
  price: Money
}

export interface CartItemOption {
  id: number
  name: string
  values: CartItemOptionValue[]
}

export interface CartItemProduct {
  id: number
  name: string
  thumbnail: string | null
}

export interface CartTax {
  id: number
  name: string
  amount: Money
}

export interface loyaltyGift {
  id: number
}

export interface CartItem {
  id: string
  qty: number
  item: CartItemProduct
  options: Record<string, CartItemOption>
  unitPrice: Money
  subtotal: Money
  taxTotal: Money
  taxes: CartTax[]
  loyaltyGift?: loyaltyGift
  actions: CartItemAction[]
  orderProduct?: OrderProduct
  total: Money
}

export interface CartItemAction {
  id: string
  quantity: number
}

export interface OrderProductStatus {
  id: string
  name: string
  icon: string
  color: string
}

export interface OrderProduct {
  id: number
  status: OrderProductStatus
}

export interface OrderType {
  id?: string | null
  name?: string | null
}

export interface Discount {
  id?: string | null
  name?: string | null
  value: Money
}

export interface Customer {
  id: number
  name: string
}

export interface Order {
  id: number
  name: string
}

export interface Cart {
  items: CartItem[]
  quantity: number
  subTotal: Money
  orderType: OrderType
  taxes: CartTax[]
  discount?: Discount
  customer: Customer | null
  order?: Order | null
  total: Money
}

export interface RefundPaymentMethod {
  id: string | number
  name: string
  color?: string
  icon?: string
}

export interface UseCart {
  data: Ref<Cart>
  cartId: string
  processing: Ref<boolean>
  applyDiscount: (id: number) => Promise<void>
  applyGift: (id: number) => Promise<boolean>
  removeDiscount: () => Promise<void>
  addCustomer: (id: number) => Promise<void>
  removeCustomer: () => Promise<void>
  getCart: () => Promise<void>
  updateItem: (id: string, qty: number) => Promise<void>
  storeItem: (params: Record<string, any>) => Promise<any>
  deleteItem: (id: string) => Promise<void>
  clear: () => Promise<void>
  storeOrderType: (type: string) => Promise<void>
  removeOrderType: () => Promise<void>
  resetCart: (response?: Cart) => void
  storeAction: (id: string, action: string, qty: number) => Promise<void>
  removeAction: (id: string, action: string) => Promise<void>
  showError: (error: any) => void
  applyVoucher: (code: string) => Promise<void>
}
