import type { RouteLocationRaw } from 'vue-router'
import type { TableAction } from '@/contracts'
import axios from 'axios'
import { useI18n } from 'vue-i18n'
import { useToast } from 'vue-toastification'
import { api } from '@/api'

export const useTableDefaultActionClick = (resource: string, refresh: () => void) => {
  const router = useRouter()

  const toast = useToast()
  const { t } = useI18n()

  const destroy = async (id?: string | number | (string | number)[] | null) => {
    try {
      if (resource == 'pos_registers') {
        resource = 'pos/registers'
      }
      const response = await api.delete(`/v1/${resource.replace('_', '-')}/${Array.isArray(id) ? id : (id == null ? [] : [id]).join(',')}`)
      if (response?.data?.message) {
        toast.success(response.data.message)
      }
      refresh()
    } catch (error) {
      if (axios.isAxiosError(error) && error.response?.data?.message) {
        toast.error(error.response.data?.message)
      } else {
        toast.error(t('core::errors.an_unexpected_error_occurred'))
      }
    }
  }

  const handleClick = async (action: TableAction, id?: string | number | (string | number)[] | null) => {
    if (action.key === 'destroy') {
      return await destroy(id)
    }

    return router.push({
      name: `admin.${resource}.${action.key}`,
      params: id ? { id } : {},
    } as unknown as RouteLocationRaw)
  }
  return { handleClick }
}
