import type { SettingSection } from '@/enums/settingSection.ts'
import { useI18n } from 'vue-i18n'
import { useToast } from 'vue-toastification'
import * as settingApi from '@/api/setting/setting.ts'
import { useAppStore, useSettingsStore } from '@/stores'

export function useSetting () {
  const toast = useToast()
  const appStore = useAppStore()

  const { t } = useI18n()
  const settingStore = useSettingsStore()
  const getSettings = async (section: SettingSection): Promise<any> => {
    settingStore.setLoading(true)
    try {
      const response = await settingApi.getSettings(section)
      settingStore.setLoading(false)
      return response.data.body
    } catch {
      toast.error(t('core::errors.failed_to_load_data'))
      settingStore.setLoading(false)
      return false
    }
  }

  const update = async (section: SettingSection, data: object) => {
    const response = await settingApi.update(section, data)
    appStore.setSettings(response.data.body.app_settings)
    return response
  }

  return { store: settingStore, getSettings, update }
}
