import type { TranslationRecord } from '@/contracts'
import { useI18n } from 'vue-i18n'
import { useToast } from 'vue-toastification'
import { getTranslations, updateTranslation } from '@/api/translation/translation.ts'

export function useLanguage () {
  const toast = useToast()
  const { t } = useI18n()

  const loadData: () => Promise<TranslationRecord[] | false> = async () => {
    try {
      return (await getTranslations()).data.body.records
    } catch {
      toast.error(t('core::errors.failed_to_load_data'))
      return false
    }
  }
  const update = async (key: string, locale: string, value: string | null) => {
    try {
      toast.success((await updateTranslation(key, locale, value)).data.message)
    } catch {
      /* Empty */
    }
  }

  const parseTitlePage = (title: string | null, params: Record<string, string> | null): string => {
    if (!title) {
      return ''
    }
    const transParams = params || {}
    const resolvedParams: Record<string, string> = {}
    for (const key in transParams) {
      resolvedParams[key] = t(transParams[key])
    }
    return t(title as string, resolvedParams)
  }
  return { loadData, parseTitlePage, update }
}
