import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/tables/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/tables/${id}`, item)
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/tables`, item)
}

export function getFormMeta (branchId?: number, floorId?: number) {
  return api.get(`/v1/tables/form/meta`, { params: { branch_id: branchId, floor_id: floorId } })
}

export function getTableViewer (branchId?: number | null) {
  return api.get(`/v1/tables/viewer`, { params: { branch_id: branchId } })
}

export function getTableViewerDetails (id: number) {
  return api.get(`/v1/tables/viewer/${id}`)
}

export function assignWaiter (id: number, params: Record<string, any>) {
  return api.patch(`/v1/tables/viewer/${id}/assign-waiter`, params)
}

export function makeAvailable (id: number) {
  return api.patch(`/v1/tables/viewer/${id}/make-available`)
}

export function merge (id: number, params: Record<string, any>) {
  return api.post(`/v1/tables/viewer/${id}/merge`, params)
}

export function split (mergeId: number) {
  return api.post(`/v1/tables/viewer/${mergeId}/split`)
}

export function getMergeMeta (id: number) {
  return api.get(`/v1/tables/viewer/${id}/merge/meta`)
}
