import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/pos/sessions/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function open (data: Record<string, any>) {
  return api.post(`/v1/pos/sessions/open`, data)
}

export function close (id: number, data: Record<string, any>) {
  return api.put(`/v1/pos/sessions/${id}/close`, data)
}

export function getFormMeta (branchId?: number) {
  return api.get(`/v1/pos/sessions/form/meta`, { params: { branch_id: branchId } })
}
