import { api } from '@/api'

export function getOrders (branchId?: number | null) {
  return api.get('/v1/pos/kitchen-viewer/orders', { params: { branch_id: branchId } })
}

export function getConfiguration (branchId?: number | null) {
  return api.get('/v1/pos/kitchen-viewer/configuration', { params: { branch_id: branchId } })
}

export function moveToNextStatus (orderId: number | string, ids?: number[]) {
  return api.patch(`/v1/pos/kitchen-viewer/${orderId}/move-to-next-status`, { ids })
}
