import { api } from '@/api'

export function get (params: Record<string, any> = {}) {
  return api.get(`/v1/media`, { params })
}

export function update (id: number, params: Record<string, any>) {
  return api.put(`/v1/media/${id}`, params)
}

export function destroy (ids: string) {
  return api.delete(`/v1/media/${ids}`)
}

export function createFolder (params: Record<string, any>) {
  return api.post('/v1/media/folder/store', params)
}
