import { api } from '@/api'

export function index (menuId: number | null) {
  return api.get(`/v1/categories`, { params: { filters: { menu_id: menuId } } })
}

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/categories/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/categories/${id}`, item)
}

export function destroy (ids: number | string) {
  return api.delete(`/v1/categories/${ids}`)
}

export function updateTree (menuId: number, tree: Record<string, any>[]) {
  return api.put(`/v1/categories/${menuId}/tree`, { tree })
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/categories`, item)
}
