import { mergeProps as _mergeProps, createVNode as _createVNode, createElementVNode as _createElementVNode } from "vue";
// Styles
import "./VCalendarIntervalEvent.css";

// Components
import { VSheet } from "../../components/VSheet/index.js"; // Composables
import { useDate } from "../../composables/date/index.js"; // Utilities
import { convertToUnit, genericComponent, getPrefixedEventHandlers, propsFactory, useRender } from "../../util/index.js";
export const makeVCalendarIntervalEventProps = propsFactory({
  allDay: Boolean,
  interval: Object,
  intervalDivisions: {
    type: Number,
    required: true
  },
  intervalDuration: {
    type: Number,
    required: true
  },
  intervalHeight: {
    type: Number,
    required: true
  },
  event: Object
}, 'VCalendarIntervalEvent');
export const VCalendarIntervalEvent = genericComponent()({
  name: 'VCalendarIntervalEvent',
  inheritAttrs: false,
  props: makeVCalendarIntervalEventProps(),
  setup(props, _ref) {
    let {
      attrs,
      emit,
      slots
    } = _ref;
    const adapter = useDate();
    const calcHeight = () => {
      if (!props.event?.first && !props.event?.last || adapter.isEqual(props.event?.end, props.interval?.end)) {
        return {
          height: `${props.intervalHeight}px`,
          margin: convertToUnit(0)
        };
      } else {
        const {
          height,
          margin
        } = Array.from({
          length: props.intervalDivisions
        }, (_, x) => (x + 1) * (props.intervalDuration / props.intervalDivisions)).reduce((total, div, index) => {
          if (adapter.isBefore(adapter.addMinutes(props.interval?.start, div), props.event?.end)) {
            return {
              height: convertToUnit(props.intervalHeight / props.intervalDivisions * index),
              margin: convertToUnit(props.intervalHeight / props.intervalDivisions * index)
            };
          }
          return {
            height: total.height,
            margin: total.margin
          };
        }, {
          height: '',
          margin: ''
        });
        return {
          height,
          margin
        };
      }
    };
    useRender(() => {
      return _createElementVNode("div", null, [slots['interval-event']?.({
        height: calcHeight().height,
        margin: calcHeight().margin,
        eventClass: 'v-calendar-internal-event',
        event: props.event,
        interval: props.interval
      }) ?? _createVNode(VSheet, _mergeProps({
        "height": calcHeight().height,
        "density": "comfortable",
        "style": `margin-top: ${calcHeight().margin}`,
        "class": "v-calendar-internal-event",
        "color": props.event?.color ?? undefined,
        "rounded": props.event?.first && props.event?.last ? true : props.event?.first ? 't' : props.event?.last ? 'b' : false
      }, getPrefixedEventHandlers(attrs, ':event', () => ({
        event: props.event,
        allDay: false,
        day: null,
        interval: props.interval,
        intervalDivisions: props.intervalDivisions,
        intervalDuration: props.intervalDuration,
        intervalHeight: props.intervalHeight
      }))), {
        default: () => [props.event?.first ? props.event?.title : '']
      })]);
    });
    return {};
  }
});
//# sourceMappingURL=VCalendarIntervalEvent.js.map