"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const rule = {
    meta: {
        type: "problem",
        docs: {
            url: (0, utils_1.makeDocsURL)("no-static-element-interactions")
        },
        messages: {
            default: "Visible, non-interactive elements should not have an interactive handler."
        },
        schema: []
    },
    create(context) {
        return (0, utils_1.defineTemplateBodyVisitor)(context, {
            VElement(node) {
                const role = (0, utils_1.getElementAttributeValue)(node, "role");
                if ((0, utils_1.isCustomComponent)(node) ||
                    (0, utils_1.isHiddenFromScreenReader)(node) ||
                    (0, utils_1.isPresentationRole)(node)) {
                    return;
                }
                if ((0, utils_1.hasOnDirectives)(node, utils_1.interactiveHandlers) &&
                    !(0, utils_1.isInteractiveElement)(node) &&
                    !(0, utils_1.isInteractiveRole)(role)) {
                    context.report({ node: node, messageId: "default" });
                }
            }
        });
    }
};
exports.default = rule;
