"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const hasFocusableElement_1 = __importDefault(require("../utils/hasFocusableElement"));
const rule = {
    meta: {
        type: "problem",
        docs: {
            url: (0, utils_1.makeDocsURL)("no-role-presentation-on-focusable")
        },
        messages: {
            default: "Focusable/Interactive elements must not have a presentation role attribute."
        },
        schema: []
    },
    create(context) {
        return (0, utils_1.defineTemplateBodyVisitor)(context, {
            VElement(node) {
                const hasRolePresentation = (0, utils_1.getElementAttributeValue)(node, "role") === "presentation";
                if (hasRolePresentation && (0, hasFocusableElement_1.default)(node)) {
                    context.report({
                        node: node,
                        messageId: "default"
                    });
                }
            }
        });
    }
};
exports.default = rule;
