"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const rule = {
    meta: {
        type: "problem",
        deprecated: true,
        docs: {
            url: (0, utils_1.makeDocsURL)("no-onchange")
        },
        messages: {
            default: "@blur must be used instead of @change, unless absolutely necessary and it causes no negative consequences for keyboard only or screen reader users."
        },
        schema: []
    },
    create(context) {
        return (0, utils_1.defineTemplateBodyVisitor)(context, {
            VElement(node) {
                if (!["select", "option"].includes((0, utils_1.getElementType)(node))) {
                    return;
                }
                if ((0, utils_1.hasOnDirective)(node, "change") && !(0, utils_1.hasOnDirective)(node, "blur")) {
                    context.report({ node: node, messageId: "default" });
                }
            }
        });
    }
};
exports.default = rule;
