"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const rule = {
    meta: {
        type: "problem",
        docs: {
            url: (0, utils_1.makeDocsURL)("click-events-have-key-events")
        },
        messages: {
            default: "Visible, non-interactive elements with click handlers must have at least one keyboard listener."
        },
        schema: []
    },
    create(context) {
        return (0, utils_1.defineTemplateBodyVisitor)(context, {
            VElement(node) {
                if (!(0, utils_1.isCustomComponent)(node) &&
                    (0, utils_1.hasOnDirective)(node, "click") &&
                    !(0, utils_1.isHiddenFromScreenReader)(node) &&
                    !(0, utils_1.isPresentationRole)(node) &&
                    !(0, utils_1.isInteractiveElement)(node) &&
                    !(0, utils_1.hasOnDirectives)(node, ["keydown", "keyup", "keypress"])) {
                    context.report({ node: node, messageId: "default" });
                }
            }
        });
    }
};
exports.default = rule;
