"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const emoji_regex_1 = __importDefault(require("emoji-regex"));
const utils_1 = require("../utils");
const rule = {
    meta: {
        type: "problem",
        docs: {
            url: (0, utils_1.makeDocsURL)("accessible-emoji")
        },
        deprecated: true,
        messages: {
            default: `Emojis should be wrapped in <span>, have role="img", and have an accessible description with aria-label or aria-labelledby.`
        },
        schema: []
    },
    create(context) {
        return (0, utils_1.defineTemplateBodyVisitor)(context, {
            VText(node) {
                if (node.value && (0, emoji_regex_1.default)().test(node.value)) {
                    const element = node.parent;
                    if (element.type === "VElement" &&
                        !(0, utils_1.isAriaHidden)(element) &&
                        (!(0, utils_1.hasAriaLabel)(element) ||
                            (0, utils_1.getElementType)(element) !== "span" ||
                            (0, utils_1.getElementAttributeValue)(element, "role") !== "img")) {
                        context.report({ node: node, messageId: "default" });
                    }
                }
            }
        });
    }
};
exports.default = rule;
