"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rules = void 0;
const node_path_1 = require("node:path");
const node_fs_1 = require("node:fs");
exports.rules = getRulesForSideBar();
function getRulesForSideBar() {
    const rulesDirectory = (0, node_path_1.join)(__dirname, "../", "rules");
    return (0, node_fs_1.readdirSync)(rulesDirectory, { withFileTypes: true })
        .filter(isFile)
        .filter(isMarkdown)
        .map(fileNameWithoutExtension)
        .map(ruleToSidebarItem);
}
function isFile(dirent) {
    return !dirent.isDirectory();
}
function isMarkdown(dirent) {
    return dirent.name.endsWith(".md");
}
function fileNameWithoutExtension(file) {
    const parsedFileName = (0, node_path_1.parse)(file.name);
    const nameWithoutExtension = parsedFileName.name;
    return nameWithoutExtension;
}
function ruleToSidebarItem(ruleName) {
    return {
        text: ruleName,
        link: `/rules/${ruleName}`
    };
}
