"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const globals_1 = __importDefault(require("globals"));
const rules_1 = require("../rules");
const recommended = [
    {
        name: "vuejs-accessibility:setup:base",
        plugins: {
            get "vuejs-accessibility"() {
                return require("../../index");
            }
        },
        languageOptions: {
            sourceType: "module",
            globals: globals_1.default.browser
        }
    },
    {
        name: "vuejs-accessibility:setup:with-files-rules-and-parser",
        files: ["*.vue", "**/*.vue"],
        plugins: {
            get "vuejs-accessibility"() {
                return require("../../index");
            }
        },
        languageOptions: {
            parser: require("vue-eslint-parser"),
            sourceType: "module",
            globals: globals_1.default.browser
        },
        rules: rules_1.rules
    }
];
module.exports = recommended;
