// Generated file, DO NOT edit
import {createRule} from './utils/rule.js';

import betterRegex from './better-regex.js';
import catchErrorName from './catch-error-name.js';
import consistentAssert from './consistent-assert.js';
import consistentDateClone from './consistent-date-clone.js';
import consistentDestructuring from './consistent-destructuring.js';
import consistentEmptyArraySpread from './consistent-empty-array-spread.js';
import consistentExistenceIndexCheck from './consistent-existence-index-check.js';
import consistentFunctionScoping from './consistent-function-scoping.js';
import customErrorDefinition from './custom-error-definition.js';
import emptyBraceSpaces from './empty-brace-spaces.js';
import errorMessage from './error-message.js';
import escapeCase from './escape-case.js';
import expiringTodoComments from './expiring-todo-comments.js';
import explicitLengthCheck from './explicit-length-check.js';
import filenameCase from './filename-case.js';
import importStyle from './import-style.js';
import newForBuiltins from './new-for-builtins.js';
import noAbusiveEslintDisable from './no-abusive-eslint-disable.js';
import noAccessorRecursion from './no-accessor-recursion.js';
import noAnonymousDefaultExport from './no-anonymous-default-export.js';
import noArrayCallbackReference from './no-array-callback-reference.js';
import noArrayForEach from './no-array-for-each.js';
import noArrayMethodThisArgument from './no-array-method-this-argument.js';
import noArrayPushPush from './no-array-push-push.js';
import noArrayReduce from './no-array-reduce.js';
import noAwaitExpressionMember from './no-await-expression-member.js';
import noAwaitInPromiseMethods from './no-await-in-promise-methods.js';
import noConsoleSpaces from './no-console-spaces.js';
import noDocumentCookie from './no-document-cookie.js';
import noEmptyFile from './no-empty-file.js';
import noForLoop from './no-for-loop.js';
import noHexEscape from './no-hex-escape.js';
import noInstanceofBuiltins from './no-instanceof-builtins.js';
import noInvalidFetchOptions from './no-invalid-fetch-options.js';
import noInvalidRemoveEventListener from './no-invalid-remove-event-listener.js';
import noKeywordPrefix from './no-keyword-prefix.js';
import noLengthAsSliceEnd from './no-length-as-slice-end.js';
import noLonelyIf from './no-lonely-if.js';
import noMagicArrayFlatDepth from './no-magic-array-flat-depth.js';
import noNamedDefault from './no-named-default.js';
import noNegatedCondition from './no-negated-condition.js';
import noNegationInEqualityCheck from './no-negation-in-equality-check.js';
import noNestedTernary from './no-nested-ternary.js';
import noNewArray from './no-new-array.js';
import noNewBuffer from './no-new-buffer.js';
import noNull from './no-null.js';
import noObjectAsDefaultParameter from './no-object-as-default-parameter.js';
import noProcessExit from './no-process-exit.js';
import noSinglePromiseInPromiseMethods from './no-single-promise-in-promise-methods.js';
import noStaticOnlyClass from './no-static-only-class.js';
import noThenable from './no-thenable.js';
import noThisAssignment from './no-this-assignment.js';
import noTypeofUndefined from './no-typeof-undefined.js';
import noUnnecessaryAwait from './no-unnecessary-await.js';
import noUnnecessaryPolyfills from './no-unnecessary-polyfills.js';
import noUnreadableArrayDestructuring from './no-unreadable-array-destructuring.js';
import noUnreadableIife from './no-unreadable-iife.js';
import noUnusedProperties from './no-unused-properties.js';
import noUselessFallbackInSpread from './no-useless-fallback-in-spread.js';
import noUselessLengthCheck from './no-useless-length-check.js';
import noUselessPromiseResolveReject from './no-useless-promise-resolve-reject.js';
import noUselessSpread from './no-useless-spread.js';
import noUselessSwitchCase from './no-useless-switch-case.js';
import noUselessUndefined from './no-useless-undefined.js';
import noZeroFractions from './no-zero-fractions.js';
import numberLiteralCase from './number-literal-case.js';
import numericSeparatorsStyle from './numeric-separators-style.js';
import preferAddEventListener from './prefer-add-event-listener.js';
import preferArrayFind from './prefer-array-find.js';
import preferArrayFlatMap from './prefer-array-flat-map.js';
import preferArrayFlat from './prefer-array-flat.js';
import preferArrayIndexOf from './prefer-array-index-of.js';
import preferArraySome from './prefer-array-some.js';
import preferAt from './prefer-at.js';
import preferBlobReadingMethods from './prefer-blob-reading-methods.js';
import preferCodePoint from './prefer-code-point.js';
import preferDateNow from './prefer-date-now.js';
import preferDefaultParameters from './prefer-default-parameters.js';
import preferDomNodeAppend from './prefer-dom-node-append.js';
import preferDomNodeDataset from './prefer-dom-node-dataset.js';
import preferDomNodeRemove from './prefer-dom-node-remove.js';
import preferDomNodeTextContent from './prefer-dom-node-text-content.js';
import preferEventTarget from './prefer-event-target.js';
import preferExportFrom from './prefer-export-from.js';
import preferGlobalThis from './prefer-global-this.js';
import preferIncludes from './prefer-includes.js';
import preferJsonParseBuffer from './prefer-json-parse-buffer.js';
import preferKeyboardEventKey from './prefer-keyboard-event-key.js';
import preferLogicalOperatorOverTernary from './prefer-logical-operator-over-ternary.js';
import preferMathMinMax from './prefer-math-min-max.js';
import preferMathTrunc from './prefer-math-trunc.js';
import preferModernDomApis from './prefer-modern-dom-apis.js';
import preferModernMathApis from './prefer-modern-math-apis.js';
import preferModule from './prefer-module.js';
import preferNativeCoercionFunctions from './prefer-native-coercion-functions.js';
import preferNegativeIndex from './prefer-negative-index.js';
import preferNodeProtocol from './prefer-node-protocol.js';
import preferNumberProperties from './prefer-number-properties.js';
import preferObjectFromEntries from './prefer-object-from-entries.js';
import preferOptionalCatchBinding from './prefer-optional-catch-binding.js';
import preferPrototypeMethods from './prefer-prototype-methods.js';
import preferQuerySelector from './prefer-query-selector.js';
import preferReflectApply from './prefer-reflect-apply.js';
import preferRegexpTest from './prefer-regexp-test.js';
import preferSetHas from './prefer-set-has.js';
import preferSetSize from './prefer-set-size.js';
import preferSpread from './prefer-spread.js';
import preferStringRaw from './prefer-string-raw.js';
import preferStringReplaceAll from './prefer-string-replace-all.js';
import preferStringSlice from './prefer-string-slice.js';
import preferStringStartsEndsWith from './prefer-string-starts-ends-with.js';
import preferStringTrimStartEnd from './prefer-string-trim-start-end.js';
import preferStructuredClone from './prefer-structured-clone.js';
import preferSwitch from './prefer-switch.js';
import preferTernary from './prefer-ternary.js';
import preferTopLevelAwait from './prefer-top-level-await.js';
import preferTypeError from './prefer-type-error.js';
import preventAbbreviations from './prevent-abbreviations.js';
import relativeUrlStyle from './relative-url-style.js';
import requireArrayJoinSeparator from './require-array-join-separator.js';
import requireNumberToFixedDigitsArgument from './require-number-to-fixed-digits-argument.js';
import requirePostMessageTargetOrigin from './require-post-message-target-origin.js';
import stringContent from './string-content.js';
import switchCaseBraces from './switch-case-braces.js';
import templateIndent from './template-indent.js';
import textEncodingIdentifierCase from './text-encoding-identifier-case.js';
import throwNewError from './throw-new-error.js';

const rules = {
	'better-regex': createRule(betterRegex, 'better-regex'),
	'catch-error-name': createRule(catchErrorName, 'catch-error-name'),
	'consistent-assert': createRule(consistentAssert, 'consistent-assert'),
	'consistent-date-clone': createRule(consistentDateClone, 'consistent-date-clone'),
	'consistent-destructuring': createRule(consistentDestructuring, 'consistent-destructuring'),
	'consistent-empty-array-spread': createRule(consistentEmptyArraySpread, 'consistent-empty-array-spread'),
	'consistent-existence-index-check': createRule(consistentExistenceIndexCheck, 'consistent-existence-index-check'),
	'consistent-function-scoping': createRule(consistentFunctionScoping, 'consistent-function-scoping'),
	'custom-error-definition': createRule(customErrorDefinition, 'custom-error-definition'),
	'empty-brace-spaces': createRule(emptyBraceSpaces, 'empty-brace-spaces'),
	'error-message': createRule(errorMessage, 'error-message'),
	'escape-case': createRule(escapeCase, 'escape-case'),
	'expiring-todo-comments': createRule(expiringTodoComments, 'expiring-todo-comments'),
	'explicit-length-check': createRule(explicitLengthCheck, 'explicit-length-check'),
	'filename-case': createRule(filenameCase, 'filename-case'),
	'import-style': createRule(importStyle, 'import-style'),
	'new-for-builtins': createRule(newForBuiltins, 'new-for-builtins'),
	'no-abusive-eslint-disable': createRule(noAbusiveEslintDisable, 'no-abusive-eslint-disable'),
	'no-accessor-recursion': createRule(noAccessorRecursion, 'no-accessor-recursion'),
	'no-anonymous-default-export': createRule(noAnonymousDefaultExport, 'no-anonymous-default-export'),
	'no-array-callback-reference': createRule(noArrayCallbackReference, 'no-array-callback-reference'),
	'no-array-for-each': createRule(noArrayForEach, 'no-array-for-each'),
	'no-array-method-this-argument': createRule(noArrayMethodThisArgument, 'no-array-method-this-argument'),
	'no-array-push-push': createRule(noArrayPushPush, 'no-array-push-push'),
	'no-array-reduce': createRule(noArrayReduce, 'no-array-reduce'),
	'no-await-expression-member': createRule(noAwaitExpressionMember, 'no-await-expression-member'),
	'no-await-in-promise-methods': createRule(noAwaitInPromiseMethods, 'no-await-in-promise-methods'),
	'no-console-spaces': createRule(noConsoleSpaces, 'no-console-spaces'),
	'no-document-cookie': createRule(noDocumentCookie, 'no-document-cookie'),
	'no-empty-file': createRule(noEmptyFile, 'no-empty-file'),
	'no-for-loop': createRule(noForLoop, 'no-for-loop'),
	'no-hex-escape': createRule(noHexEscape, 'no-hex-escape'),
	'no-instanceof-builtins': createRule(noInstanceofBuiltins, 'no-instanceof-builtins'),
	'no-invalid-fetch-options': createRule(noInvalidFetchOptions, 'no-invalid-fetch-options'),
	'no-invalid-remove-event-listener': createRule(noInvalidRemoveEventListener, 'no-invalid-remove-event-listener'),
	'no-keyword-prefix': createRule(noKeywordPrefix, 'no-keyword-prefix'),
	'no-length-as-slice-end': createRule(noLengthAsSliceEnd, 'no-length-as-slice-end'),
	'no-lonely-if': createRule(noLonelyIf, 'no-lonely-if'),
	'no-magic-array-flat-depth': createRule(noMagicArrayFlatDepth, 'no-magic-array-flat-depth'),
	'no-named-default': createRule(noNamedDefault, 'no-named-default'),
	'no-negated-condition': createRule(noNegatedCondition, 'no-negated-condition'),
	'no-negation-in-equality-check': createRule(noNegationInEqualityCheck, 'no-negation-in-equality-check'),
	'no-nested-ternary': createRule(noNestedTernary, 'no-nested-ternary'),
	'no-new-array': createRule(noNewArray, 'no-new-array'),
	'no-new-buffer': createRule(noNewBuffer, 'no-new-buffer'),
	'no-null': createRule(noNull, 'no-null'),
	'no-object-as-default-parameter': createRule(noObjectAsDefaultParameter, 'no-object-as-default-parameter'),
	'no-process-exit': createRule(noProcessExit, 'no-process-exit'),
	'no-single-promise-in-promise-methods': createRule(noSinglePromiseInPromiseMethods, 'no-single-promise-in-promise-methods'),
	'no-static-only-class': createRule(noStaticOnlyClass, 'no-static-only-class'),
	'no-thenable': createRule(noThenable, 'no-thenable'),
	'no-this-assignment': createRule(noThisAssignment, 'no-this-assignment'),
	'no-typeof-undefined': createRule(noTypeofUndefined, 'no-typeof-undefined'),
	'no-unnecessary-await': createRule(noUnnecessaryAwait, 'no-unnecessary-await'),
	'no-unnecessary-polyfills': createRule(noUnnecessaryPolyfills, 'no-unnecessary-polyfills'),
	'no-unreadable-array-destructuring': createRule(noUnreadableArrayDestructuring, 'no-unreadable-array-destructuring'),
	'no-unreadable-iife': createRule(noUnreadableIife, 'no-unreadable-iife'),
	'no-unused-properties': createRule(noUnusedProperties, 'no-unused-properties'),
	'no-useless-fallback-in-spread': createRule(noUselessFallbackInSpread, 'no-useless-fallback-in-spread'),
	'no-useless-length-check': createRule(noUselessLengthCheck, 'no-useless-length-check'),
	'no-useless-promise-resolve-reject': createRule(noUselessPromiseResolveReject, 'no-useless-promise-resolve-reject'),
	'no-useless-spread': createRule(noUselessSpread, 'no-useless-spread'),
	'no-useless-switch-case': createRule(noUselessSwitchCase, 'no-useless-switch-case'),
	'no-useless-undefined': createRule(noUselessUndefined, 'no-useless-undefined'),
	'no-zero-fractions': createRule(noZeroFractions, 'no-zero-fractions'),
	'number-literal-case': createRule(numberLiteralCase, 'number-literal-case'),
	'numeric-separators-style': createRule(numericSeparatorsStyle, 'numeric-separators-style'),
	'prefer-add-event-listener': createRule(preferAddEventListener, 'prefer-add-event-listener'),
	'prefer-array-find': createRule(preferArrayFind, 'prefer-array-find'),
	'prefer-array-flat-map': createRule(preferArrayFlatMap, 'prefer-array-flat-map'),
	'prefer-array-flat': createRule(preferArrayFlat, 'prefer-array-flat'),
	'prefer-array-index-of': createRule(preferArrayIndexOf, 'prefer-array-index-of'),
	'prefer-array-some': createRule(preferArraySome, 'prefer-array-some'),
	'prefer-at': createRule(preferAt, 'prefer-at'),
	'prefer-blob-reading-methods': createRule(preferBlobReadingMethods, 'prefer-blob-reading-methods'),
	'prefer-code-point': createRule(preferCodePoint, 'prefer-code-point'),
	'prefer-date-now': createRule(preferDateNow, 'prefer-date-now'),
	'prefer-default-parameters': createRule(preferDefaultParameters, 'prefer-default-parameters'),
	'prefer-dom-node-append': createRule(preferDomNodeAppend, 'prefer-dom-node-append'),
	'prefer-dom-node-dataset': createRule(preferDomNodeDataset, 'prefer-dom-node-dataset'),
	'prefer-dom-node-remove': createRule(preferDomNodeRemove, 'prefer-dom-node-remove'),
	'prefer-dom-node-text-content': createRule(preferDomNodeTextContent, 'prefer-dom-node-text-content'),
	'prefer-event-target': createRule(preferEventTarget, 'prefer-event-target'),
	'prefer-export-from': createRule(preferExportFrom, 'prefer-export-from'),
	'prefer-global-this': createRule(preferGlobalThis, 'prefer-global-this'),
	'prefer-includes': createRule(preferIncludes, 'prefer-includes'),
	'prefer-json-parse-buffer': createRule(preferJsonParseBuffer, 'prefer-json-parse-buffer'),
	'prefer-keyboard-event-key': createRule(preferKeyboardEventKey, 'prefer-keyboard-event-key'),
	'prefer-logical-operator-over-ternary': createRule(preferLogicalOperatorOverTernary, 'prefer-logical-operator-over-ternary'),
	'prefer-math-min-max': createRule(preferMathMinMax, 'prefer-math-min-max'),
	'prefer-math-trunc': createRule(preferMathTrunc, 'prefer-math-trunc'),
	'prefer-modern-dom-apis': createRule(preferModernDomApis, 'prefer-modern-dom-apis'),
	'prefer-modern-math-apis': createRule(preferModernMathApis, 'prefer-modern-math-apis'),
	'prefer-module': createRule(preferModule, 'prefer-module'),
	'prefer-native-coercion-functions': createRule(preferNativeCoercionFunctions, 'prefer-native-coercion-functions'),
	'prefer-negative-index': createRule(preferNegativeIndex, 'prefer-negative-index'),
	'prefer-node-protocol': createRule(preferNodeProtocol, 'prefer-node-protocol'),
	'prefer-number-properties': createRule(preferNumberProperties, 'prefer-number-properties'),
	'prefer-object-from-entries': createRule(preferObjectFromEntries, 'prefer-object-from-entries'),
	'prefer-optional-catch-binding': createRule(preferOptionalCatchBinding, 'prefer-optional-catch-binding'),
	'prefer-prototype-methods': createRule(preferPrototypeMethods, 'prefer-prototype-methods'),
	'prefer-query-selector': createRule(preferQuerySelector, 'prefer-query-selector'),
	'prefer-reflect-apply': createRule(preferReflectApply, 'prefer-reflect-apply'),
	'prefer-regexp-test': createRule(preferRegexpTest, 'prefer-regexp-test'),
	'prefer-set-has': createRule(preferSetHas, 'prefer-set-has'),
	'prefer-set-size': createRule(preferSetSize, 'prefer-set-size'),
	'prefer-spread': createRule(preferSpread, 'prefer-spread'),
	'prefer-string-raw': createRule(preferStringRaw, 'prefer-string-raw'),
	'prefer-string-replace-all': createRule(preferStringReplaceAll, 'prefer-string-replace-all'),
	'prefer-string-slice': createRule(preferStringSlice, 'prefer-string-slice'),
	'prefer-string-starts-ends-with': createRule(preferStringStartsEndsWith, 'prefer-string-starts-ends-with'),
	'prefer-string-trim-start-end': createRule(preferStringTrimStartEnd, 'prefer-string-trim-start-end'),
	'prefer-structured-clone': createRule(preferStructuredClone, 'prefer-structured-clone'),
	'prefer-switch': createRule(preferSwitch, 'prefer-switch'),
	'prefer-ternary': createRule(preferTernary, 'prefer-ternary'),
	'prefer-top-level-await': createRule(preferTopLevelAwait, 'prefer-top-level-await'),
	'prefer-type-error': createRule(preferTypeError, 'prefer-type-error'),
	'prevent-abbreviations': createRule(preventAbbreviations, 'prevent-abbreviations'),
	'relative-url-style': createRule(relativeUrlStyle, 'relative-url-style'),
	'require-array-join-separator': createRule(requireArrayJoinSeparator, 'require-array-join-separator'),
	'require-number-to-fixed-digits-argument': createRule(requireNumberToFixedDigitsArgument, 'require-number-to-fixed-digits-argument'),
	'require-post-message-target-origin': createRule(requirePostMessageTargetOrigin, 'require-post-message-target-origin'),
	'string-content': createRule(stringContent, 'string-content'),
	'switch-case-braces': createRule(switchCaseBraces, 'switch-case-braces'),
	'template-indent': createRule(templateIndent, 'template-indent'),
	'text-encoding-identifier-case': createRule(textEncodingIdentifierCase, 'text-encoding-identifier-case'),
	'throw-new-error': createRule(throwNewError, 'throw-new-error'),
};

export default rules;
