"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UNICODE_SCRIPT_ALIAS = exports.UNICODE_GENERAL_CATEGORY_ALIAS = exports.UNICODE_BINARY_PROPERTY_ALIAS = exports.UNICODE_CATEGORY_ALIAS = exports.AliasMap = void 0;
class AliasMap {
    constructor({ shortToLong, otherToLong, }) {
        const toShortMap = new Map();
        const toLongMap = new Map();
        for (const [short, long] of Object.entries(shortToLong)) {
            toShortMap.set(long, short);
            toLongMap.set(short, long);
        }
        for (const [other, long] of Object.entries(otherToLong)) {
            toLongMap.set(other, long);
            const short = toShortMap.get(long);
            if (!short) {
                throw new Error(`No short key for ${long} with other key ${other}`);
            }
            toShortMap.set(other, short);
        }
        this.toShortMap = toShortMap;
        this.toLongMap = toLongMap;
    }
    toShort(key) {
        return this.toShortMap.get(key) || key;
    }
    toLong(key) {
        return this.toLongMap.get(key) || key;
    }
}
exports.AliasMap = AliasMap;
exports.UNICODE_CATEGORY_ALIAS = new AliasMap({
    shortToLong: {
        gc: "General_Category",
        sc: "Script",
        scx: "Script_Extensions",
    },
    otherToLong: {},
});
exports.UNICODE_BINARY_PROPERTY_ALIAS = new AliasMap({
    shortToLong: {
        AHex: "ASCII_Hex_Digit",
        Alpha: "Alphabetic",
        Bidi_C: "Bidi_Control",
        Bidi_M: "Bidi_Mirrored",
        CE: "Composition_Exclusion",
        CI: "Case_Ignorable",
        Comp_Ex: "Full_Composition_Exclusion",
        CWCF: "Changes_When_Casefolded",
        CWCM: "Changes_When_Casemapped",
        CWKCF: "Changes_When_NFKC_Casefolded",
        CWL: "Changes_When_Lowercased",
        CWT: "Changes_When_Titlecased",
        CWU: "Changes_When_Uppercased",
        Dep: "Deprecated",
        DI: "Default_Ignorable_Code_Point",
        Dia: "Diacritic",
        EBase: "Emoji_Modifier_Base",
        EComp: "Emoji_Component",
        EMod: "Emoji_Modifier",
        EPres: "Emoji_Presentation",
        Ext: "Extender",
        ExtPict: "Extended_Pictographic",
        Gr_Base: "Grapheme_Base",
        Gr_Ext: "Grapheme_Extend",
        Gr_Link: "Grapheme_Link",
        Hex: "Hex_Digit",
        IDC: "ID_Continue",
        Ideo: "Ideographic",
        IDS: "ID_Start",
        IDSB: "IDS_Binary_Operator",
        IDST: "IDS_Trinary_Operator",
        IDSU: "IDS_Unary_Operator",
        Join_C: "Join_Control",
        LOE: "Logical_Order_Exception",
        Lower: "Lowercase",
        MCM: "Modifier_Combining_Mark",
        NChar: "Noncharacter_Code_Point",
        OAlpha: "Other_Alphabetic",
        ODI: "Other_Default_Ignorable_Code_Point",
        OGr_Ext: "Other_Grapheme_Extend",
        OIDC: "Other_ID_Continue",
        OIDS: "Other_ID_Start",
        OLower: "Other_Lowercase",
        OMath: "Other_Math",
        OUpper: "Other_Uppercase",
        Pat_Syn: "Pattern_Syntax",
        Pat_WS: "Pattern_White_Space",
        PCM: "Prepended_Concatenation_Mark",
        QMark: "Quotation_Mark",
        RI: "Regional_Indicator",
        SD: "Soft_Dotted",
        STerm: "Sentence_Terminal",
        Term: "Terminal_Punctuation",
        UIdeo: "Unified_Ideograph",
        Upper: "Uppercase",
        VS: "Variation_Selector",
        WSpace: "White_Space",
        XIDC: "XID_Continue",
        XIDS: "XID_Start",
        XO_NFC: "Expands_On_NFC",
        XO_NFD: "Expands_On_NFD",
        XO_NFKC: "Expands_On_NFKC",
        XO_NFKD: "Expands_On_NFKD",
    },
    otherToLong: {
        space: "White_Space",
    },
});
exports.UNICODE_GENERAL_CATEGORY_ALIAS = new AliasMap({
    shortToLong: {
        C: "Other",
        Cc: "Control",
        Cf: "Format",
        Cn: "Unassigned",
        Co: "Private_Use",
        Cs: "Surrogate",
        L: "Letter",
        LC: "Cased_Letter",
        Ll: "Lowercase_Letter",
        Lm: "Modifier_Letter",
        Lo: "Other_Letter",
        Lt: "Titlecase_Letter",
        Lu: "Uppercase_Letter",
        M: "Mark",
        Mc: "Spacing_Mark",
        Me: "Enclosing_Mark",
        Mn: "Nonspacing_Mark",
        N: "Number",
        Nd: "Decimal_Number",
        Nl: "Letter_Number",
        No: "Other_Number",
        P: "Punctuation",
        Pc: "Connector_Punctuation",
        Pd: "Dash_Punctuation",
        Pe: "Close_Punctuation",
        Pf: "Final_Punctuation",
        Pi: "Initial_Punctuation",
        Po: "Other_Punctuation",
        Ps: "Open_Punctuation",
        S: "Symbol",
        Sc: "Currency_Symbol",
        Sk: "Modifier_Symbol",
        Sm: "Math_Symbol",
        So: "Other_Symbol",
        Z: "Separator",
        Zl: "Line_Separator",
        Zp: "Paragraph_Separator",
        Zs: "Space_Separator",
    },
    otherToLong: {
        cntrl: "Control",
        Combining_Mark: "Mark",
        digit: "Decimal_Number",
        punct: "Punctuation",
    },
});
exports.UNICODE_SCRIPT_ALIAS = new AliasMap({
    shortToLong: {
        Adlm: "Adlam",
        Aghb: "Caucasian_Albanian",
        Arab: "Arabic",
        Armi: "Imperial_Aramaic",
        Armn: "Armenian",
        Avst: "Avestan",
        Bali: "Balinese",
        Bamu: "Bamum",
        Bass: "Bassa_Vah",
        Batk: "Batak",
        Beng: "Bengali",
        Bhks: "Bhaiksuki",
        Bopo: "Bopomofo",
        Brah: "Brahmi",
        Brai: "Braille",
        Bugi: "Buginese",
        Buhd: "Buhid",
        Cakm: "Chakma",
        Cans: "Canadian_Aboriginal",
        Cari: "Carian",
        Cher: "Cherokee",
        Chrs: "Chorasmian",
        Copt: "Coptic",
        Cpmn: "Cypro_Minoan",
        Cprt: "Cypriot",
        Cyrl: "Cyrillic",
        Deva: "Devanagari",
        Diak: "Dives_Akuru",
        Dogr: "Dogra",
        Dsrt: "Deseret",
        Dupl: "Duployan",
        Egyp: "Egyptian_Hieroglyphs",
        Elba: "Elbasan",
        Elym: "Elymaic",
        Ethi: "Ethiopic",
        Gara: "Garay",
        Geor: "Georgian",
        Glag: "Glagolitic",
        Gong: "Gunjala_Gondi",
        Gonm: "Masaram_Gondi",
        Goth: "Gothic",
        Gran: "Grantha",
        Grek: "Greek",
        Gujr: "Gujarati",
        Gukh: "Gurung_Khema",
        Guru: "Gurmukhi",
        Hang: "Hangul",
        Hani: "Han",
        Hano: "Hanunoo",
        Hatr: "Hatran",
        Hebr: "Hebrew",
        Hira: "Hiragana",
        Hluw: "Anatolian_Hieroglyphs",
        Hmng: "Pahawh_Hmong",
        Hmnp: "Nyiakeng_Puachue_Hmong",
        Hrkt: "Katakana_Or_Hiragana",
        Hung: "Old_Hungarian",
        Ital: "Old_Italic",
        Java: "Javanese",
        Kali: "Kayah_Li",
        Kana: "Katakana",
        Khar: "Kharoshthi",
        Khmr: "Khmer",
        Khoj: "Khojki",
        Kits: "Khitan_Small_Script",
        Knda: "Kannada",
        Krai: "Kirat_Rai",
        Kthi: "Kaithi",
        Lana: "Tai_Tham",
        Laoo: "Lao",
        Latn: "Latin",
        Lepc: "Lepcha",
        Limb: "Limbu",
        Lina: "Linear_A",
        Linb: "Linear_B",
        Lyci: "Lycian",
        Lydi: "Lydian",
        Mahj: "Mahajani",
        Maka: "Makasar",
        Mand: "Mandaic",
        Mani: "Manichaean",
        Marc: "Marchen",
        Medf: "Medefaidrin",
        Mend: "Mende_Kikakui",
        Merc: "Meroitic_Cursive",
        Mero: "Meroitic_Hieroglyphs",
        Mlym: "Malayalam",
        Mong: "Mongolian",
        Mroo: "Mro",
        Mtei: "Meetei_Mayek",
        Mult: "Multani",
        Mymr: "Myanmar",
        Nagm: "Nag_Mundari",
        Nand: "Nandinagari",
        Narb: "Old_North_Arabian",
        Nbat: "Nabataean",
        Nkoo: "Nko",
        Nshu: "Nushu",
        Ogam: "Ogham",
        Olck: "Ol_Chiki",
        Onao: "Ol_Onal",
        Orkh: "Old_Turkic",
        Orya: "Oriya",
        Osge: "Osage",
        Osma: "Osmanya",
        Ougr: "Old_Uyghur",
        Palm: "Palmyrene",
        Pauc: "Pau_Cin_Hau",
        Perm: "Old_Permic",
        Phag: "Phags_Pa",
        Phli: "Inscriptional_Pahlavi",
        Phlp: "Psalter_Pahlavi",
        Phnx: "Phoenician",
        Plrd: "Miao",
        Prti: "Inscriptional_Parthian",
        Rjng: "Rejang",
        Rohg: "Hanifi_Rohingya",
        Runr: "Runic",
        Samr: "Samaritan",
        Sarb: "Old_South_Arabian",
        Saur: "Saurashtra",
        Sgnw: "SignWriting",
        Shaw: "Shavian",
        Shrd: "Sharada",
        Sidd: "Siddham",
        Sind: "Khudawadi",
        Sinh: "Sinhala",
        Sogd: "Sogdian",
        Sogo: "Old_Sogdian",
        Sora: "Sora_Sompeng",
        Soyo: "Soyombo",
        Sund: "Sundanese",
        Sunu: "Sunuwar",
        Sylo: "Syloti_Nagri",
        Syrc: "Syriac",
        Tagb: "Tagbanwa",
        Takr: "Takri",
        Tale: "Tai_Le",
        Talu: "New_Tai_Lue",
        Taml: "Tamil",
        Tang: "Tangut",
        Tavt: "Tai_Viet",
        Telu: "Telugu",
        Tfng: "Tifinagh",
        Tglg: "Tagalog",
        Thaa: "Thaana",
        Tibt: "Tibetan",
        Tirh: "Tirhuta",
        Tnsa: "Tangsa",
        Todr: "Todhri",
        Tutg: "Tulu_Tigalari",
        Ugar: "Ugaritic",
        Vaii: "Vai",
        Vith: "Vithkuqi",
        Wara: "Warang_Citi",
        Wcho: "Wancho",
        Xpeo: "Old_Persian",
        Xsux: "Cuneiform",
        Yezi: "Yezidi",
        Yiii: "Yi",
        Zanb: "Zanabazar_Square",
        Zinh: "Inherited",
        Zyyy: "Common",
        Zzzz: "Unknown",
    },
    otherToLong: {
        Qaac: "Coptic",
        Qaai: "Inherited",
    },
});
