"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQuantifierOffsets = getQuantifierOffsets;
exports.quantToString = quantToString;
function getQuantifierOffsets(qNode) {
    const startOffset = qNode.element.end - qNode.start;
    const endOffset = qNode.raw.length - (qNode.greedy ? 0 : 1);
    return [startOffset, endOffset];
}
function quantToString(quant) {
    if (quant.max < quant.min ||
        quant.min < 0 ||
        !Number.isInteger(quant.min) ||
        !(Number.isInteger(quant.max) || quant.max === Infinity)) {
        throw new Error(`Invalid quantifier { min: ${quant.min}, max: ${quant.max} }`);
    }
    let value;
    if (quant.min === 0 && quant.max === 1) {
        value = "?";
    }
    else if (quant.min === 0 && quant.max === Infinity) {
        value = "*";
    }
    else if (quant.min === 1 && quant.max === Infinity) {
        value = "+";
    }
    else if (quant.min === quant.max) {
        value = `{${quant.min}}`;
    }
    else if (quant.max === Infinity) {
        value = `{${quant.min},}`;
    }
    else {
        value = `{${quant.min},${quant.max}}`;
    }
    if (quant.greedy === false) {
        return `${value}?`;
    }
    return value;
}
