/**
 * Encode SVG for use in url()
 *
 * Short alternative to encodeURIComponent() that encodes only stuff used in SVG, generating
 * smaller code.
 */
declare function encodeSVGforURL(svg: string): string;
/**
 * Generate data: URL from SVG
 */
declare function svgToData(svg: string): string;
/**
 * Generate url() from SVG
 */
declare function svgToURL(svg: string): string;

export { encodeSVGforURL, svgToData, svgToURL };
