import { SVG } from '../svg/index.cjs';
import 'cheerio';
import '@iconify/types';
import '@iconify/utils/lib/customisations/defaults';

/**
 * Removes clip path from SVG, which Figma and Penpot add to icons that might have overflowing elements.
 * Also removes mess generated by Penpot
 *
 * Function was originally designed for Figma only, but later added support for Penpot
 */
declare function removeFigmaClipPathFromSVG(svg: SVG): boolean;

export { removeFigmaClipPathFromSVG };
