import "./chunk-QDKKXY3Z.js";
import {
  Fragment,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createVNode,
  defineComponent,
  inject,
  isProxy,
  isReactive,
  isRef,
  normalizeStyle,
  onMounted,
  onUnmounted,
  openBlock,
  provide,
  ref,
  renderList,
  resolveComponent,
  resolveDynamicComponent,
  toRaw,
  unref,
  vShow,
  watch,
  withDirectives,
  withModifiers
} from "./chunk-LPSI4ICB.js";
import "./chunk-BYYN2XO5.js";

// node_modules/vue-tree-dnd/dist/vue-tree-dnd.js
var R = (v) => {
  const o = [], n = (i, d = []) => {
    o.push({
      ...i,
      __vue_dnd_tree_ancestors: d
    });
    for (const u of i.children)
      n(u, [...d, i.id]);
  };
  return v.forEach((i) => {
    n(i);
  }), o;
};
function de(v) {
  const o = (n) => Array.isArray(n) ? n.map((i) => o(i)) : isRef(n) || isReactive(n) || isProxy(n) ? o(toRaw(n)) : n && typeof n == "object" ? Object.keys(n).reduce((i, d) => (i[d] = o(n[d]), i), {}) : n;
  return o(v);
}
var ae = (v, o, n) => Math.min(Math.max(v, o), n);
var ie = {
  key: 0,
  style: { display: "flex", "flex-direction": "row", "align-items": "center", opacity: "0.3", "pointer-events": "none" }
};
var A = defineComponent({
  __name: "TreeNode",
  props: {
    item: {},
    component: {},
    ancestors: {},
    depth: {},
    deltaX: {},
    isGhost: { type: Boolean },
    locked: { type: Boolean }
  },
  setup(v) {
    var M, X, B;
    const o = v;
    if (!o.item)
      throw new Error("item is required");
    if (typeof ((M = o.item) == null ? void 0 : M.id) != "string" && typeof ((X = o.item) == null ? void 0 : X.id) != "number" || o.item.id === "")
      throw new Error("item.id is required");
    if (!Array.isArray((B = o.item) == null ? void 0 : B.children))
      throw new Error("item.children array is required");
    if (!("expanded" in o.item))
      throw new Error("item.expanded is required");
    if (!o.component)
      throw new Error("component is required");
    const n = inject("setExpanded", () => {
      throw new Error("setExpanded has not been provided");
    }), i = (e) => {
      n(e, o.item.id);
    }, d = inject("dropTarget"), u = inject("dragItem"), y = inject("dragstart"), j = (e, s, l) => {
      if (y === void 0)
        throw new Error("VueTreeDnd has not been provided");
      y(e, s, l);
    }, T = inject("dragover"), N = (e, s) => {
      if (T === void 0)
        throw new Error("VueTreeDnd has not been provided");
      T(e, s);
    }, p = computed(() => {
      if ((u == null ? void 0 : u.value) == null)
        return [];
      const e = u.value.id;
      if (o.item.children.filter((l) => l.id !== e).length > 0 && o.item.expanded)
        return [{ id: e, targetId: o.item.id, position: "FIRST_CHILD", ghostIndent: o.depth + 1 }];
      const s = (l) => o.depth - (o.ancestors.length - l);
      return [
        ...o.ancestors.map((l, t) => ({
          id: e,
          targetId: l,
          position: "RIGHT",
          ghostIndent: s(t)
        })),
        { id: e, targetId: o.item.id, position: "RIGHT", ghostIndent: o.depth },
        { id: e, targetId: o.item.id, position: "LAST_CHILD", ghostIndent: o.depth + 1 }
      ];
    }), m = computed(() => {
      const e = Math.min(...p.value.map((l) => l.ghostIndent)), s = Math.max(...p.value.map((l) => l.ghostIndent));
      return ae(o.deltaX, e, s);
    }), C = inject("setDropProposal"), f = (e) => {
      if (C === void 0)
        throw new Error("VueTreeDnd has not been provided");
      C(e);
    };
    watch([d, p, m], () => {
      if (!(d === void 0 || (d == null ? void 0 : d.value) === null) && d.value === o.item.id) {
        const e = p.value.find((s) => s.ghostIndent === m.value);
        if (e == null)
          throw new Error(`Could not find impliedMoveMutation for ghostIndent ${m.value}`);
        f(e);
      }
    });
    const w = {
      position: "absolute",
      opacity: 0,
      pointerEvents: "none"
    }, b = computed(() => {
      var e;
      return ((e = u == null ? void 0 : u.value) == null ? void 0 : e.id) === o.item.id && !o.isGhost ? w : {};
    });
    return (e, s) => {
      var t;
      const l = resolveComponent("TreeNode", true);
      return openBlock(), createElementBlock("a", {
        href: "javascript:;",
        style: normalizeStyle([{ color: "inherit", "text-decoration": "none" }, b.value])
      }, [
        createBaseVNode("div", {
          style: { display: "flex", "flex-direction": "row", "align-items": "center" },
          onDragover: s[0] || (s[0] = (r) => N(r, e.item.id))
        }, [
          (openBlock(), createBlock(resolveDynamicComponent(e.component), {
            item: e.item,
            depth: e.depth,
            expanded: e.item.expanded,
            onSetExpanded: i
          }, null, 40, ["item", "depth", "expanded"]))
        ], 32),
        unref(d) === e.item.id && !e.isGhost && unref(u) !== void 0 ? (openBlock(), createElementBlock("div", ie, [
          createVNode(l, {
            item: unref(u),
            component: e.component,
            ancestors: [],
            "drop-target": unref(d),
            depth: m.value,
            "delta-x": e.deltaX,
            "is-ghost": true,
            locked: e.locked
          }, null, 8, ["item", "component", "drop-target", "depth", "delta-x", "locked"])
        ])) : createCommentVNode("", true),
        (openBlock(true), createElementBlock(Fragment, null, renderList(((t = e.item) == null ? void 0 : t.children) || [], (r, a) => {
          var c, h, O;
          return withDirectives((openBlock(), createBlock(l, {
            key: r.id,
            item: r,
            component: e.component,
            ancestors: a === e.item.children.length - 1 || a === e.item.children.length - 2 && ((c = unref(u)) == null ? void 0 : c.id) === ((O = (h = e.item) == null ? void 0 : h.children[e.item.children.length - 1]) == null ? void 0 : O.id) ? [...e.ancestors, e.item.id] : [],
            "drop-target": unref(d),
            depth: e.depth + 1,
            "delta-x": e.deltaX,
            "is-ghost": e.isGhost,
            locked: e.locked,
            draggable: !e.locked,
            onDragstart: withModifiers((z) => j(z, r.id, e.depth + 1), ["stop"])
          }, null, 8, ["item", "component", "ancestors", "drop-target", "depth", "delta-x", "is-ghost", "locked", "draggable", "onDragstart"])), [
            [vShow, e.item.expanded]
          ]);
        }), 128))
      ], 4);
    };
  }
});
var se = {
  key: 0,
  style: { display: "flex", "flex-direction": "row", "align-items": "center", opacity: "0.3", "pointer-events": "none" }
};
var P = "__vue-dnd-tree-root__";
var ue = defineComponent({
  __name: "VueTreeDnd",
  props: {
    modelValue: {},
    component: {},
    locked: { type: Boolean }
  },
  emits: ["move", "update:modelValue"],
  setup(v, { emit: o }) {
    const n = v, i = ref([]), d = ref([]), u = (t) => i.value.find((r) => r.id === t);
    watch(() => n.modelValue, () => {
      i.value = R(n.modelValue), d.value = i.value.map(({ id: t }) => t);
    }, { immediate: true, deep: true }), provide("setExpanded", (t, r) => {
      const a = structuredClone(de(n.modelValue)), c = (h) => {
        h.id === r && (h.expanded = t), h.children !== void 0 && h.children.forEach(c);
      };
      a.forEach(c), o("update:modelValue", a);
    });
    const y = (t) => {
      const r = d.value.findIndex((a) => a === t);
      return r === 0 ? P : d.value[r - 1];
    }, j = (t) => {
      if (t === P)
        return false;
      const r = i.value.find((c) => c.id === t);
      if (r === void 0)
        throw new Error(`targetId ${t} not found in flatTreeNodes`);
      return r.__vue_dnd_tree_ancestors.some((c) => {
        var h;
        return !(((h = u(c)) == null ? void 0 : h.expanded) ?? false);
      });
    }, T = ref(0), N = (t) => {
      if (t.preventDefault(), e.value === null)
        throw new Error("VueTreeDnd has not correctly set dataTransfer data (missing)");
      const { initialX: r, initialDepth: a } = e.value, c = Math.round((+t.clientX - r) / 20);
      T.value = a + c;
    };
    onMounted(() => {
      document.addEventListener("dragover", N);
    }), onUnmounted(() => {
      document.removeEventListener("dragover", N);
    });
    const p = ref(null), m = computed(() => i.value.find((t) => t.id === p.value));
    provide("dragItem", m);
    const C = computed(() => m.value === void 0 ? /* @__PURE__ */ new Set() : new Set(R([m.value]).map((t) => t.id))), f = ref(null), w = (t) => {
      if (C.value.has(t) || j(t)) {
        w(y(t));
        return;
      }
      f.value = t;
    };
    provide("dropTarget", f), provide("setDropTarget", w);
    const b = ref(null), M = (t) => {
      b.value = t;
    };
    provide("setDropProposal", M), watch(f, () => {
      if (f.value === P) {
        if (p.value === null)
          throw new Error("dragItemId.value is null");
        M({
          id: p.value,
          targetId: n.modelValue[0].id,
          position: "LEFT",
          ghostIndent: 0
        });
      }
    });
    const X = () => {
      if (b.value == null)
        return;
      f.value = null, p.value = null;
      const { ghostIndent: t, ...r } = b.value;
      r.id !== r.targetId && o("move", r);
    }, B = new Image(), e = ref(null), s = (t, r, a) => {
      t.dataTransfer !== null && (t.dataTransfer.dropEffect = "none", t.dataTransfer.effectAllowed = "none", t.dataTransfer.setDragImage(B, 0, 0)), setTimeout(() => {
        p.value = r, e.value = {
          initialX: t.clientX,
          initialDepth: a
        }, w(y(r));
      }, 0);
    };
    return provide("dragstart", s), provide("dragover", (t, r) => {
      t.preventDefault();
      const a = y(r);
      if (p.value === r) {
        w(a);
        return;
      }
      w(t.offsetY < t.target.clientHeight / 2 ? a : r);
    }), (t, r) => (openBlock(), createElementBlock("div", { onDragend: X }, [
      f.value === P && m.value !== void 0 ? (openBlock(), createElementBlock("div", se, [
        createVNode(A, {
          item: m.value,
          component: t.component,
          ancestors: [],
          depth: 0,
          "delta-x": T.value,
          "is-ghost": true,
          locked: t.locked
        }, null, 8, ["item", "component", "delta-x", "locked"])
      ])) : createCommentVNode("", true),
      (openBlock(true), createElementBlock(Fragment, null, renderList(t.modelValue || [], (a) => (openBlock(), createBlock(A, {
        key: a.id,
        item: a,
        component: t.component,
        ancestors: [],
        depth: 0,
        "drop-target": f.value,
        "delta-x": T.value,
        "is-ghost": false,
        locked: t.locked,
        draggable: !t.locked,
        onDragstart: withModifiers((c) => s(c, a.id, 0), ["stop"])
      }, null, 8, ["item", "component", "drop-target", "delta-x", "locked", "draggable", "onDragstart"]))), 128))
    ], 32));
  }
});
export {
  ue as default
};
//# sourceMappingURL=vue-tree-dnd.js.map
